/*

Copyright (C) 2005, Panic, Inc.  All rights reserved.
Code and art: C. Sasser

No portion of this code may be duplicated or reproduced in another widget 
without written permission from Panic, Inc. Contact: info@panic.com

Let us know if you make any improvements or have any new ideas!

1.0 - 4/22/05 - First release

*/

var transferGoing = null;
var resultLast = null;

//
// ANIM FUNCTIONS
// So, so many
//

// This is a three part animation.
// 6 frames at the beginning, 16 frames in the middle, 6 frames at the end.
// Since we don't know when we'll be done, loop until we get the signal.

var roadAnimation = {timer:null, img:null, current:-1, animating:false, shouldstop:false};

function roadAnimate () {

	// If we got the call to stop, set us to "end" state

	if (roadAnimation.shouldStop == "true" && roadAnimation.state != "end") {
		roadAnimation.current = -1;
		roadAnimation.state = "end";
	}

	if (roadAnimation.state == "beginning") {
		
		// Fade in
		
		roadAnimation.current += 1;
		
		if (roadAnimation.current > 5) {
			roadAnimation.current = -1;
			roadAnimation.state = "middle";
		} else {
			var src = "Images/animf-";
			src += '0' + roadAnimation.current + '.png';
			roadAnimation.img.src = src;
		}
		
	} else if (roadAnimation.state == "middle") {

		// Running normally

		roadAnimation.current +=1;
		
		if (roadAnimation.current > 17) roadAnimation.current = 0;
		
		var src = "Images/anim-";
		
		if (roadAnimation.current < 10)
			src += '0' + roadAnimation.current;
		else
			src += roadAnimation.current;
			
		src += '.png';
	
		roadAnimation.img.src = src;
		
	} else if (roadAnimation.state == "end") {
	
		// Fade out
	
		roadAnimation.current += 1;
		
		if (roadAnimation.current > 5) {
			clearInterval(roadAnimation.timer);
			roadAnimation.timer = null;
			roadAnimation.animating = false;
			roadAnimation.img.src = "Default.png";
		} else {
			var src = "Images/animi-";
			src += '0' + roadAnimation.current + '.png';
			roadAnimation.img.src = src;
		}		
	}
}

function roadStart() {

	// alert("Road animation start called.");

	roadAnimation.current = -1;
	roadAnimation.img = document.getElementById('base');
	roadAnimation.shouldStop = false;
	roadAnimation.animating = true;
	roadAnimation.state = "beginning";
	roadAnimation.timer = setInterval ("roadAnimate();", 30);
	
}

function roadStop() {

	// alert("Road animation stop called.");
	
	// Send a signal to the animation timer that we need to finish.
	// If our timer is null, that probably means we're hidden, so clear it out.
	// Otherwise, setting shouldStop will play the "finishing" animation.
	
	if (roadAnimation.timer != null) {
		roadAnimation.shouldStop = "true";
	} else {
		clearInterval(roadAnimation.timer);
		roadAnimation.timer = null;
		roadAnimation.animating = false;
		roadAnimation.img.src = "Default.png";
	}
}

//
// The Spinner anim actually sets the _background_ image of a <img>. Tricky!
//
// Note: this USED to be a spinner. I ran out of time after changing it dot a
// dot, so while I should just be adjusting the opacity of the dot (a la 
// weather) and only using one graphic, it's just a bog-standard .png animation.

var spinAnimation = {timer:null, elem:null, current:-1, animating:false};

function spinAnimate() {

	spinAnimation.current +=1;
	
	if (spinAnimation.current > 11) spinAnimation.current = 0;
	
	var src = "Images/spin-";
	
	if (spinAnimation.current < 10)
		src += '0' + spinAnimation.current;
	else
		src += spinAnimation.current;
		
	src += '.png';
	
	spinAnimation.elem.style.backgroundImage = "url("+src+")";
}

function spinStart() {
	spinAnimation.current = -1;
	spinAnimation.elem = document.getElementById('favicon');
	spinAnimation.animating = true;
	spinAnimation.timer = setInterval ("spinAnimate();", 50);
}

function spinStop() {
	spinAnimation.elem.style.backgroundImage = 'Images/spacer.gif';
	clearInterval(spinAnimation.timer);
	spinAnimation.timer = null;
	spinAnimation.animating = false;
}

//
// This is used to fade the status text and fade in the status icon simultaneously
// "duration" in the following struct is how long we want the transition to go for
//

var statusAnimation = {timer: null, alphaNow:1.0, alpha2Now: 0.0, duration:1000, start:null};

function statusAnimationTimer ()
{
	var time = (new Date).getTime();
	var fraction;
	var fraction2;
	
	fraction = 1.0 - (time - statusAnimation.start) / statusAnimation.duration; // Down
	fraction2 = (time - statusAnimation.start) / statusAnimation.duration;      // Up
	
	statusAnimation.alphaNow = fraction;
	statusAnimation.alpha2Now = fraction2;
	
	// If we've faded out, we're done
	
	if (statusAnimation.alphaNow < 0.0) {
		clearInterval(statusAnimation.timer);
		statusAnimation.timer = null;
	}
	
	// Calculate
	
    var sine = Math.sin((Math.PI/2.0) * statusAnimation.alphaNow);
    var sine2 = Math.sin((Math.PI/2.0) * statusAnimation.alpha2Now);

    statusAnimation.alphaNow = sine * sine;
    statusAnimation.alpha2Now = sine2 * sine2;
    
    // Set text and status icon
    
    document.getElementById('fronttext').style.opacity = statusAnimation.alphaNow;
    document.getElementById('statusicon').style.opacity = statusAnimation.alpha2Now;
    
    // Also set error text (if appropriate). Should maybe not rely on the image
    // source to determine if we errored out or not... you never know, yeah?
    // Another future idea: put the icon and the text in a containing div. Then we're
    // only setting one item, not three -- not that it really makes that much of a diff.

	if (resultlast == "error") {
		document.getElementById('errortextleft').style.opacity = statusAnimation.alpha2Now;
		document.getElementById('errortextright').style.opacity = statusAnimation.alpha2Now;
	}
}

function startStatusAnimation ()
{
	if (statusAnimation.timer != null)
	{
		clearInterval (statusAnimation.timer);
		statusAnimation.timer = null;
	}
	
	// Setup status icon and status text, just in case
	
	var statusicon = document.getElementById('statusicon');
	statusicon.style.opacity = '0.0';
	statusicon.style.display = 'inline';

	var fronttext = document.getElementById('fronttext');
	fronttext.style.opacity = '1.0';
	fronttext.style.display = 'inline';
	
	// Setup error text, just in case as well
	
	if (resultlast == "error") {
		var statusleft = document.getElementById('errortextleft');
		statusleft.style.opacity = '0.0';
		statusleft.style.display = 'inline';
		var statusright = document.getElementById('errortextright');
		statusright.style.opacity = '0.0';
		statusright.style.display = 'inline';
	}
	
	// Now begin the animation
	
	statusAnimation.alphaNow = 1.0;
	statusAnimation.alpha2Now = 0.0;
	statusAnimation.start = (new Date).getTime() - 60;
	statusAnimation.timer = setInterval ('statusAnimationTimer();', 60);
}

//
// Drop Hint Animation
//
// This is our final animation. This one is a bit fun because 
// each frame of the middle section anim is defined in an array, allowing for
// minimum graphics with repeating frames. Additionally, each frame can have
// its own opacity.

var hintAnimation = {timer:null, img:null, current:-1, animating:false};
var arrowArray = new Array(0,0,0,1,2,3,4,4,4,5,6,7, 0,0,0,1,2,3,4,4,4,5,6,7, 0,0,0,1,2,3,4,4,4,5,6,7, 0,0,0,0,0,0);
var arrowOpact = new Array(0,.2,.4,.6,.8,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1, 1,.8,.6,.4,.2,0);

function hintAnimate () {

	if (hintAnimation.state == "beginning") {
		
		// Fade out
		
		hintAnimation.current += 1;
		
		if (hintAnimation.current > 6) {
			hintAnimation.current = -1;
			hintAnimation.state = "middle";
			hintAnimation.img2.style.display = "inline";
		} else {
			var src = "Images/truckopen-";
			src += '0' + hintAnimation.current + '.png';
			
			// alert(src);
			
			hintAnimation.img.src = src;
		}
		
	} else if (hintAnimation.state == "middle") {

		// Running normally

		hintAnimation.current +=1;
		
		if ((hintAnimation.current + 1) > arrowArray.length) {
			hintAnimation.current = 7;
			hintAnimation.state = "end";
		} else {
		
			var src = "Images/arrow-";
			
			if (arrowArray[hintAnimation.current] < 10)
				src += '0' + arrowArray[hintAnimation.current];
			else
				src += arrowArray[hintAnimation.current];
				
			src += '.png';
			
			// alert(src);
			// alert(arrowOpact[hintAnimation.current]);
		
			hintAnimation.img2.src = src;
			hintAnimation.img2.style.opacity = arrowOpact[hintAnimation.current];
	
		}
		
	} else if (hintAnimation.state == "end") {
	
		// Fade in
	
		hintAnimation.current -= 1;
		
		if (hintAnimation.current < 0) {
			clearInterval(hintAnimation.timer);
			hintAnimation.timer = null;
			hintAnimation.animating = false;
			hintAnimation.img.src = "Default.png";
			hintAnimation.img2.style.opacity = 0;
			hintAnimation.img2.style.display = "none";			
		} else {
			var src = "Images/truckopen-";
			src += '0' + hintAnimation.current + '.png';
			// alert(src);
			hintAnimation.img.src = src;
		}		
	}
}

function hintStart() {
	if (hintAnimation.animating != true) {
		hintAnimation.current = -1;
		hintAnimation.img = document.getElementById('base');
		hintAnimation.img2 = document.getElementById('hintarrow');
		hintAnimation.animating = true;
		hintAnimation.state = "beginning";
		hintAnimation.timer = setInterval ("hintAnimate();", 40);
	}
}

function hintStop() {

	// Really only ever called before an upload, just in case

	if (hintAnimation.timer != null) {
		clearInterval(hintAnimation.timer);
		hintAnimation.timer = null;
		hintAnimation.animating = false;
		hintAnimation.img.src = "Default.png";
		hintAnimation.img2.style.opacity = 0;
		hintAnimation.img2.style.display = "none";
	}
}

//
// SETUP FUNCTIONS.
// Called on widget creation, reload.
//

function doSetup() {

	// Set the text labels to proper localized fields

	document.getElementById('serverlabel').innerText = getLocalizedString('Server:');
	document.getElementById('userlabel').innerText = getLocalizedString('User:');
	document.getElementById('passlabel').innerText = getLocalizedString('Pass:');
	document.getElementById('pathlabel').innerText = getLocalizedString('Path:');

	// Load Preferences into Text Fields
	// In the case of protocol, since it may not be changed, save it outright

	if (window.widget)
	{
	
		pref = widget.preferenceForKey(createKey("server"));
		if (pref != null)
		{
			document.getElementById('serverinput').value = pref;
		}

		pref = widget.preferenceForKey(createKey("user"));
		if (pref != null)
		{
			document.getElementById('userinput').value = pref;
		}

		pref = widget.preferenceForKey(createKey("pass"));
		if (pref != null)
		{
			document.getElementById('passinput').value = pref;
		}		
		
		pref = widget.preferenceForKey(createKey("path"));
		if (pref != null)
		{
			document.getElementById('pathinput').value = pref;
		}
		
		pref = widget.preferenceForKey(createKey("protocol"));
		if (pref != null)
		{
			document.getElementById('protocolinput').options.namedItem(pref).selected = true;
		} else {
			pref = "FTP";
			document.getElementById('protocolinput').options.namedItem(pref).selected = true;
			prefChanged(document.getElementById('protocolinput'), 'protocol');
		}
		
	}
	
	// Draw the generic "Done" button on the back
			
	createGenericButton(document.getElementById('done'), getLocalizedString('Done'), hidePrefs);

	// Update the front with the text, favicon, etc.
	
	updateFront();

	// alert("Widget initialization complete.");

}

//
// WIDGET EVENTS
//

if (window.widget) {
	widget.onremove = onremove;
	widget.onshow = onshow;
	widget.onhide = onhide;
}

// Delete all of the prefs when a widget is destroyed

function onremove () {
	if (window.widget) {
		widget.setPreferenceForKey (null, createKey("server"));
		widget.setPreferenceForKey (null, createKey("user"));
		widget.setPreferenceForKey (null, createKey("path"));
		widget.setPreferenceForKey (null, createKey("pass"));
		widget.setPreferenceForKey (null, createKey("protocol"));
	}
}

// Restart the animations (if they were already going)

function onshow () {
	if (roadAnimation.animating) {
		// alert("Road animation started (again).");
		roadAnimation.timer = setInterval('roadAnimate();', 30);
	}
	
	if (spinAnimation.animating) {
		// alert("Spin animation started (again).");
		spinAnimation.timer = setInterval('spinAnimate();', 50);
	}
	
	// There's a chance the checkmark is still showing because
	// the transfer finished when we were hidden. 
	// In that case, we clear it out here just in case.
	
	if (! transferGoing && document.getElementById('statusicon').style.opacity != '0.0') {
		var statusicon = document.getElementById('statusicon');
		statusicon.style.opacity = '0.0';
		statusicon.style.display = 'none';

		var fronttext = document.getElementById('fronttext');
		fronttext.style.opacity = '1.0';
		fronttext.style.display = 'inline';
		
		document.getElementById('errortextleft').style.display = 'none';
		document.getElementById('errortextright').style.display = 'none';
	}
}

// Pause the animation on hide (no wasted cycles or trans fats)

function onhide () {
	if (roadAnimation.animating) {
		// alert("Road animation stopped (hiding).");
		clearInterval(roadAnimation.timer);
		roadAnimation.timer = null;
	}
	if (spinAnimation.animating) {
		// alert("Spin animation stopped (hiding).");
		clearInterval(spinAnimation.timer);
		spinAnimation.timer = null;
	}

	// If a transfer is done, as we hide we should reset the status icon 
	// so that we're ready to take a new drag the next time we're shown.
	
	if (! transferGoing) {
		var statusicon = document.getElementById('statusicon');
		statusicon.style.opacity = '0.0';
		statusicon.style.display = 'none';

		var fronttext = document.getElementById('fronttext');
		fronttext.style.opacity = '1.0';
		fronttext.style.display = 'inline';
		
		document.getElementById('errortextleft').style.display = 'none';
		document.getElementById('errortextright').style.display = 'none';		
	}
}

//
// DRAG AND DROP FUNCTIONS
//

function dragdrop (event) {

	if (serverinput.value != "") {

		var uri = null;
	
		try {
		
			// for (var i = 0; i < event.dataTransfer.types.length; i++) {
			//	alert(i+" ("+event.dataTransfer.types[i]+") = "+event.dataTransfer.getData(event.dataTransfer.types[i]));
			// }
	
			uri = event.dataTransfer.getData("text/uri-list");	// attempt to load the URL
			
		} catch (ex) {
			alert("No text/uri-list?");
		}
		
		// if the acquisition is successful:
		if (uri)
		{
	
			// ANIM - Start animating!
			
			hintStop(); 	// Just in case
			roadStart();
			
			// Split the supplied list of URI's into a JavaScript array
			
			files_array = uri.split("\n");
			
			// Do the upload

			if (window.widget && serverinput.value) {
				resultlast = "";
				doUpload(serverinput.value, userinput.value, passinput.value, pathinput.value, protocolinput.value, files_array);
			}
		
		}
		
	}
	
	event.stopPropagation();
	event.preventDefault();

}

// The dragenter, dragover, and dragleave functions are implemented but not used.  They
// can be used if you want to change the image when it enters the widget.

function dragenter (event) {

	// If the user hasn't defined a server, or a transfer is in progress, we can't take a drop

	if (! serverinput.value || transferGoing) {
		event.dataTransfer.dropEffect = "none";
	}

	event.stopPropagation();
	event.preventDefault();
}

function dragover (event) {

	// If the user hasn't defined a server, or a transfer is in progress, we can't take a drop

	if (! serverinput.value || transferGoing) {
		event.dataTransfer.dropEffect = "none";
	}

	event.stopPropagation();
	event.preventDefault();
}

function dragleave (event) {
	event.stopPropagation();
	event.preventDefault();
}

//
// DISPLAY FUNCTIONS
//

function updateFront() {

	// Find the right text for the "path" line

	if (pathinput.value == "") {
		displayPath = "";
	} else if (transferGoing != null) {
		displayPath = getLocalizedString('Uploading...');
	} else {
		displayPath = pathinput.value;
	}
	
	// Find the right text for the "server" line. If not configured, note it,
	// and link it. Otherwise, just print the server name.
	
	if (serverinput.value == "") {
		displayServer = getLocalizedString('Not Configured');
		document.getElementById('siteName').innerHTML = "<a href='javascript:showPrefs()'>"+displayServer+"</a>";
	} else {
		displayServer = serverinput.value;
		document.getElementById('siteName').innerText = displayServer;
	}

	// Display the path name as well
	
	document.getElementById('pathName').innerText = displayPath;
	
	updateFavicon();
	
}

// Update the favicon (do this only when necessary)

function updateFavicon() {

	// Get the last part of the server url (.thing.com)
	// If it's foreign with two two-letter bits (i.e. .co.uk), we need the last three chunks
	// Otherwise, we need the last two chunks

	dotOne = serverinput.value.lastIndexOf(".");
	dotTwo = serverinput.value.lastIndexOf(".", dotOne - 1);

	if (dotOne - dotTwo < 4) {
		dotThree = serverinput.value.lastIndexOf(".", dotTwo - 1);
		lastPart = serverinput.value.substr(dotThree + 1);
	} else {
		dotTwo = serverinput.value.lastIndexOf(".", dotOne - 1);
		lastPart = serverinput.value.substr(dotTwo + 1);
	}

	// Now, construct the FavIcon path from the root URL

	favPath = "http://www."+lastPart+"/favicon.ico";

	// Change the loader url, only if it's different

	if (serverinput.value != "" && favloader.src != favPath) {
		favicon.src = 'Images/spacer.gif';
		if (spinAnimation.animating != true) {
			spinStart();
		}
		favloader.src = favPath;
		
		// alert("Favloader set to "+favloader.src);

	} else if (serverinput.value == "") {
		favloader.src = 'Images/favicon.png';
	}
	
}

function favLoad() {
	// alert("Favicon loaded OK.");
	spinStop();
	favicon.src = favloader.src;
}

function favError() {
	// alert("Favicon didn't load OK.");
	spinStop();
	favicon.src = 'images/favicon.png';
}

//
// UPLOAD FUNCTIONS
//

// Actually launch the script to upload the file

function doUpload(server, user, pass, path, protocol, farray) {

	// Test multi-file array to make sure we're ready when it actually works (bring on 10.4.1!)
	// farray = ["file://localhost/Users/test/Desktop/Picture%201.png","file://localhost/Users/test/Desktop/Picture%202.png","file://localhost/Users/test/Desktop/Picture%203.png"]

	if (server == "") {
		server = "__none__";
	}
	if (user == "") {
		user = "__none__";
	}
	if (pass == "") {
		pass = "__none__";
	}
	if (path == "") {
		path = "__none__";
	}
	
	// Start the command
	
	command = '/usr/bin/osascript -s o TransmitUpload.scpt "'+server+'" "'+user+'" "'+pass+'" "'+path+'" "'+protocol+'" ';
	
	// For each of the files, append the file as an argument, unescaped and with file:// stripped
	
	for (var i = 0; i < farray.length; i++) {
		// alert("Adding "+i);
		command += '"'+unescape(farray[i].replace(/file\:\/\/localhost/gi, ""))+'" ';
	}
	
	// Now fire the command. When it's done, the command will call uploadFinished().
	
	// alert("Launching script async: "+command);
	transferGoing = widget.system(command, uploadFinished);
	
	updateFront();
	
}

function uploadFinished() {

	output = transferGoing.outputString;
	// alert("Script finished. Return: "+output);
	output = output.replace(/(\n)|(\r)/gi, "");
	
	transferGoing = null;
	
	// Now decide what to do

	if (output == "ok") {
	
		// Everything went well. Display the "OK" icon.

		var resulticon = document.getElementById('resulticon');
		resulticon.src = "Images/status-ok.png";

		resultlast = "ok";
			
	} else {
		
		alert("Script error: "+output+" "+output.indexOf("Couldn't upload"));
		
		// Everything did not, actually, go well. Display the error icon.

		var resulticon = document.getElementById('resulticon');
		resulticon.src = "Images/status-error.png";
		
		// So I split the error string into two parts, on the left and right
		// of the error icon. I'm not so sure this is a brilliant idea by
		// any stretch, and I wonder if there's a better way -- can text wrap
		// around a <div>? I'm guessing that's as likely as a non-fat Twinkie.
		
		var errortextleft = document.getElementById('errortextleft');
		var errortextright = document.getElementById('errortextright');
		
		if (output == "Couldn't find Transmit") {
			errortextleft.innerText  = getLocalizedString("Can't find");
			errortextright.innerText = getLocalizedString("Transmit 3");
		} else if (output == "Transmit 3 Required") {
			errortextleft.innerText  = getLocalizedString("Transmit 3");
			errortextright.innerText = getLocalizedString("required");
		} else if (output == "Couldn't connect") {
			errortextleft.innerText  = getLocalizedString("Couldn't");
			errortextright.innerText = getLocalizedString("connect");
		} else if (output == "Couldn't set path") {
			errortextleft.innerText  = getLocalizedString("Couldn't");
			errortextright.innerText = getLocalizedString("set path");
		} else if (output.indexOf("Couldn't upload") == 0) {			// Includes filename
			errortextleft.innerText  = getLocalizedString("Couldn't");
			errortextright.innerText = getLocalizedString("upload");
		} else {
			errortextleft.innerText  = getLocalizedString("Unknown");
			errortextright.innerText = getLocalizedString("error.");
		}

		resultlast = "error";
		
	}
	
	// ANIM - Finish animating!
	
	roadStop();
	updateFront();
	startStatusAnimation();
	
}

//
// UTILITY FUNCTIONS
//

// Create a prefs key with the widget's unique id

function createKey(key) {
	return widget.identifier + "-" + key;
}

// Grab a localized string from our imported file

function getLocalizedString (key) {
	try {
		var ret = localizedStrings[key];
		if (ret === undefined)
			ret = key;
		return ret;
	} catch (ex) {}

	return key;
}


// 
// PREFERENCES FUNCTIONS
//

function prefChanged(select, key) {
	if (window.widget) {
		// alert("Setting key "+createKey(key)+" to value "+select.value);
		widget.setPreferenceForKey(select.value, createKey(key));
	}
	updateFront();
}

// -----------------------------------------------------------------------------
//
// FLIPPER
// What follows is Apple's standard flipper magic

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button
}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front

	// If the user configured a server, then display the "drop" hint.
	
	if (serverinput.value != "")
		setTimeout('hintStart();', 750);	// I wish there was a way to get notified when the flip is complete!
	
}

// PREFERENCE BUTTON ANIMATION (the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.

// A structure that holds information that is needed for the animation to run.

var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event) {
	if (!flipShown)	{							// if the preferences flipper is not already showing...
		if (animation.timer != null) {			// reset the animation timer value, in case a value was left behind
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');				// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event) {
	if (flipShown) {
		// fade in the flip widget
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate() {
	var T;
	var ease;
	var time = (new Date).getTime();
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration) {
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event) {
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
	document.getElementById('fliprollie').style.display = 'none';
}